(defun c:t0 ()
	(setvar "CMDECHO" 0)
	(setvar "BLIPMODE" 0)
	(setq pontos2d (getvar "osmode"))
	(setq pontos3d (getvar "3dosmode"))
	(setvar "osmode" 0)
	(setvar "3dosmode" 0)
	(setq largura (getreal "\nQual a distncia em x? " ))
	(setq comprimento (getreal "\nQual a distncia em y? " ))
	(command "ucs" (getpoint "\nIndique o ponto de insero: ") "")
	;colunas/pilares
		(command "rectangle" (list 0.02 0.02) (list 0.27 0.27))
		(ext 3)
		(command "array" (entlast) "" "R" 3 3 (/ (- comprimento 0.29) 2) (/ (- largura 0.29) 2))
		
	;pavimento
	(command "rectangle" (list 0 0) 
						(list largura comprimento)
						)
	(ext -0.2)
;	(command "extrude" (entlast) "" -0.2)
	
	
	;paredes exteriores
	(command "rectangle" (list 0 0) 
						(list largura comprimento)
						)
	(reg)
	(setq e1 (entlast))
	(command "rectangle" (list 0.3 -0.3) 
						(list (- largura 0.3) (- comprimento 0.3))
						)
	(reg)
	(setq e2 (entlast))
	(command "subtract" e1 "" e2 "")
	(setq paredes (entlast))
	
	;vo porta exterior
	(command "rectangle" (list (setq val1 (alea (* largura 0.5) (* largura 0.7))) (/ comprimento 2)) (list (+ val1 0.9) (+ comprimento 1)))	
	(reg)
	(setq vporta (entlast))
	
	(command "subtract" paredes "" vporta "")
	
	
	;desenho da wc
	(command "rectangle" (list 0.2 (setq val3 (alea (/ comprimento 2) (/ comprimento 2)))) 
    					 (list (setq val4 (alea (/ largura 4) (/ largura 2))) (- comprimento 0.2))					 
						 )
	(reg)
	(setq e3 (entlast))
	(command "rectangle" (list 0.3 (+ val3 0.2)) 
						 (list (- val4 0.2) (- comprimento 0.2)))
	(reg)
	(setq e4 (entlast))
	(command "subtract" e3 "" e4 "")
	(setq wc (entlast))	
	
	
	;desenho do vo da porta Wc
	(command "rectangle" (list 0.5 (setq val5 (- comprimento 0.4))) (list (- largura 0.5) (- val5 0.65)))
	(reg)
	(command "subtract" wc "" (entlast) "")
		(setq wc (entlast))	

	;adicionar parede para cozinha
	(command "rectangle" (list (alea (* largura 0.66) (* largura 0.83))
							(setq val2 (alea (* comprimento 0.55) (* comprimento 0.75)))) 
						 (list (- largura 0.2) (+ val2 0.10))
						 )
	(reg)
	(setq e5 (entlast))	
	
	
	;unir as paredes
	(command "union" wc paredes e5 "")	
	
	
	;desenha a altura das paredes
	(ext 3)
		
	
	;desenhar porta exterior
	(command "color" 1)
	(command "rectangle" (list val1 (- comprimento 0.3)) (list (+ val1 0.9) (- comprimento 0.25)))
	(reg)
	(ext 3)
	(command "color" "bylayer")
		
	;desenhar porta wc
	(command "color" 2)
	(command "rectangle" (list (- val4 0.2) val5) (list (+ (- val4 0.2) 0.05) (- val5 0.65)))
	(reg)
	(ext 3)
	(command "color" "bylayer")
	;desenhar a janela 1
	(command "3dpoly"   (list 0.3 0.02 0)
						(list 0.3 0.02 3)
						(list (- (/ largura 2) 0.125) 0.02 3)
						(list (- (/ largura 2) 0.125) 0.02 0)
						"cl")
	(setq caminho (entlast))
	(command "rectangle" (list 0.3 0.02 1.5)
							(list 0.35 0.07 1.5)
							)
	(setq e6 (entlast))
		(command "color" 5)	
	(command "extrude" e6 "" "p" caminho )
		(command "color" "bylayer")		
	
	
	;desenhar a janela 2
	(command "3dpoly"   (list (+ (/ largura 2) 0.125) 0.02 0)
						(list (+ (/ largura 2) 0.125) 0.02 3)
						(list (- largura 0.3) 0.02 3)
						(list (- largura 0.3) 0.02 0)
						"cl")
	(setq caminho (entlast))
	(command "rectangle" (list (+ (/ largura 2) 0.125) 0.02 1.5)
						 (list (+ (/ largura 2) 0.175) 0.07 1.5)
							)
	(setq e6 (entlast))
		(command "color" 5)	
	(command "extrude" e6 "" "p" caminho )
		(command "color" "bylayer")	
		
	;;;desenho da bancada
	(command "color" 3)	
		(command "box" (list (- largura 0.8) 1 0.1) (list (- largura 0.3)  (- (+ val2 0.10) 0.10) 0.8))
	(command "color" "bylayer")	

		;;;desenho do armrio
	(command "color" 3)	
		(command "box" (list (- largura 0.75) 1 1.7) (list (- largura 0.3)  (- (+ val2 0.10) 0.1) 2.5))
	(command "color" "bylayer")	
	
	
	;;;terminar funo T0
	(command "ucs" "")

	(setvar "osmode" pontos2d)
	(setvar "3dosmode" pontos3d)
)

(defun reg ()
	(command "region" (entlast) "")
)
(defun ext (ex)
		(command "extrude" (entlast) "" ex)	
)

(defun alea ( min max / )
	(+ min (valor (- max min)))
)
(defun valor ( num / )
	(* num (rnd))
)
(defun rnd (/ modulus multiplier increment random)
  (if (not seed)
    (setq seed (getvar "DATE"))
  )
  (setq modulus    65536
        multiplier 25173
        increment  13849
        seed  (rem (+ (* multiplier seed) increment) modulus)
        random     (/ seed modulus)
  )
)
